-- Macro_Scripts File
-- Purpose:  define action for each creatable AEC Primitive objects to hook up to the create main menu (or quads)

/*
Revision History

	24 Mai 2003: Pierre-felix Breton
		created for 3ds MAX 6

	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macro file can be shared with all Discreet products

*/

-- Macro Scripts for Objects
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK



----------------------------------------------------------------------------------------------------
--Doors
macroScript PivotDoor 
category:~PIVOTDOOR_CATEGORY~
internalCategory:"Objects AEC" 
tooltip:~PIVOTDOOR_TOOLTIP~ 
buttontext:~PIVOTDOOR_BUTTONTEXT~ 
icon:#("ObjectsAEC_Doors",1)
(
StartObjectCreation pivot 
)

macroScript BifoldDoor
category:~BIFOLDDOOR_CATEGORY~
internalCategory:"Objects AEC"
tooltip:~BIFOLDDOOR_TOOLTIP~ 
buttontext:~BIFOLDDOOR_BUTTONTEXT~ 
icon:#("ObjectsAEC_Doors",2)
(
StartObjectCreation BiFold
)

macroScript SlidingDoor 
category:~SLIDINGDOOR_CATEGORY~ 
internalCategory:"Objects AEC"
tooltip:~SLIDINGDOOR_TOOLTIP~
buttontext:~SLIDINGDOOR_BUTTONTEXT~ 
icon:#("ObjectsAEC_Doors",3)
(
StartObjectCreation SlidingDoor
)


----------------------------------------------------------------------------------------------------
--Windows
macroScript AwningWindow 
category:~AWNINGWINDOW_CATEGORY~ 
internalCategory:"Objects AEC"
tooltip:~AWNINGWINDOW_TOOLTIP~
buttontext:~AWNINGWINDOW_BUTTONTEXT~
icon:#("ObjectsAEC_Win",1)
(
StartObjectCreation Awning 
)

macroScript FixedWindow 
category:~FIXEDWINDOW_CATEGORY~ 
internalCategory:"Objects AEC"
tooltip:~FIXEDWINDOW_TOOLTIP~ 
buttontext:~FIXEDWINDOW_BUTTONTEXT~ 
icon:#("ObjectsAEC_Win",3)
(
StartObjectCreation Fixed
)

macroScript ProjectedWindow
category:~PROJECTEDWINDOW_CATEGORY~ 
internalCategory:"Objects AEC"
tooltip:~PROJECTEDWINDOW_TOOLTIP~ 
buttontext:~PROJECTEDWINDOW_BUTTONTEXT~ 
icon:#("ObjectsAEC_Win",5)
(
StartObjectCreation projected
)

macroScript CasementWindow 
category:~CASEMENTWINDOW_CATEGORY~ 
internalCategory:"Objects AEC"
tooltip:~CASEMENTWINDOW_TOOLTIP~ 
buttontext:~CASEMENTWINDOW_BUTTONTEXT~ 
icon:#("ObjectsAEC_Win",2)
(
StartObjectCreation Casement
)

macroScript PivotedWindow 
category:~CASEMENT_CATEGORY~ 
internalCategory:"Objects AEC"
tooltip:~CASEMENT_TOOLTIP~ 
buttontext:~CASEMENT_BUTTONTEXT~ 
icon:#("ObjectsAEC_Win",4)
(
StartObjectCreation Pivoted
)

macroScript SlidingWindow 
category:~SLIDINGWINDOW_CATEGORY~ 
internalCategory:"Objects AEC"
tooltip:~SLIDINGWINDOW_TOOLTIP~ 
buttontext:~SLIDINGWINDOW_BUTTONTEXT~ 
icon:#("ObjectsAEC_Win",6)
(
StartObjectCreation SlidingWindow 
)



----------------------------------------------------------------------------------------------------
--Foliage
macroScript Foliage 
category:~FOLIAGE_CATEGORY~ 
internalCategory:"Objects AEC"
tooltip:~FOLIAGE_TOOLTIP~ 
buttontext:~FOLIAGE_BUTTONTEXT~ 
icon:#("ObjectsAEC_misc",1)
(
cui.CommandPanelOpen = true
StartObjectCreation Foliage
)



----------------------------------------------------------------------------------------------------
--Railing
macroScript Railing 
category:~RAILING_CATEGORY~ 
internalCategory:"Objects AEC"
tooltip:~RAILING_TOOLTIP~ 
buttontext:~RAILING_BUTTONTEXT~ 
icon:#("ObjectsAEC_misc",2)
(
StartObjectCreation Railing
)



----------------------------------------------------------------------------------------------------
--Stairs
macroScript SpiralStair 
category:~SPIRALSTAIR_CATEGORY~ 
internalCategory:"Objects AEC"
tooltip:~SPIRALSTAIR_TOOLTIP~ 
buttontext:~SPIRALSTAIR_BUTTONTEXT~ 
icon:#("ObjectsAEC_Stairs",4)
(
StartObjectCreation Spiral_Stair
)

macroScript L_Stair 
category:~L_STAIR_CATEGORY~ 
internalCategory:"Objects AEC"
tooltip:~L_STAIR_TOOLTIP~ 
buttontext:~L_STAIR_BUTTONTEXT~ 
icon:#("ObjectsAEC_Stairs",1)
(
StartObjectCreation L_Type_Stair
)

macroScript StraightStair 
category:~STRAIGHTSTAIR_CATEGORY~ 
internalCategory:"Objects AEC"
tooltip:~STRAIGHTSTAIR_TOOLTIP~ 
buttontext:~STRAIGHTSTAIR_BUTTONTEXT~ 
icon:#("ObjectsAEC_Stairs",3)
(
StartObjectCreation Straight_Stair
)

macroScript U_Stair 
category:~U_STAIR_CATEGORY~
internalCategory:"Objects AEC"
tooltip:~U_STAIR_TOOLTIP~ 
buttontext:~U_STAIR_BUTTONTEXT~ 
icon:#("ObjectsAEC_Stairs",2)
(
StartObjectCreation U_Type_Stair
)



----------------------------------------------------------------------------------------------------
--Wall
macroScript Wall 
category:~WALL_CATEGORY~ 
internalCategory:"Objects AEC"
tooltip:~WALL_TOOLTIP~
buttontext:~WALL_BUTTONTEXT~
icon:#("ObjectsAEC_misc",3)
(
StartObjectCreation Wall
)


